//************************************************************
//---------------XiAn AnaDig IC Inc.(XAD-IC)------------------
//-----------------C File Standard--------------------
//************************************************************
//#Author      : mjw
//#Case name   : io_rw
//#Function    : Timer2_Capture   PA4作为捕捉通道，TIMER2作为捕捉定时器，上升沿触发；通过uart打印查看捕捉时长
//************************************************************
#include "AD18F08_Com.h"
#include "AD18F08.h"
#include <stdio.h>
#include "periph.h"
#include "AD18F08_Com.h"
#include "shell.h"


__CONFIG(1,_FINTOSC_DIV1_1L     & _DBG_OFF_1L       & _LVREN_ON_1L     & _LVR24V_1L                                                                   );
__CONFIG(2,_FLASH_CP1_OFF_2L    & _FLASH_CP0_OFF_2L & _IDIS_OFF_2L     & _CKSUM_OFF_2L  & _CBP_OFF_2L   & _RESETE_OFF_2L & _RSEL_LOW_2L & _STV_ON_2L  );
__CONFIG(3,_PSUT_2_3L           & _FCPU_4T_3L       & _WDTEN_OFF_3L    & _TWDT_000_3L                                                                 );
__CONFIG(4,_OSCM_HIRC_16M_4L    & _ADCSP_ON_4L                                                                                                        );

volatile unsigned char Chip_ID = 0;
#define SAMP_NUM 1
uint32_t freq;
uint32_t period;
uint16_t ccp_count=0;	//122@1000ms
uint32_t ccpr_buf=0;	//0x7a1200@1000ms
uint16_t ccpr_temp;
uint16_t ccpr_old;
uint16_t ccpr_delt;
unsigned char start_flag=1;


/***********************************************************************
 *
 *
 *
 *
 *
 * Note:PA4作为采集通道   TIMER2时钟源为Fsys 1/16分频 = 1MHz；   Uart_BPS = 9600  Tx = PB1
***********************************************************************/
void main(void)
{
	GPIO_Init();
    usart_init();
    printf("AD18F08_test\r\n");
	Timer2_Timer();
    CCP_init();
    IPEN = 0;	   	//禁止中断优先级
    PEIE = 1;    	//外设GIEL
    GIE = 1;     	//全局GIEH
     while(1)
     {
		if(start_flag==3)
		{
			start_flag=1;
			period=ccpr_buf/(ccp_count);	//us

			GIE = 0;
			printf ("period=%lu us\r\n",period);

            ccpr_buf=0;
            ccp_count=0;
            start_flag=1;

			CCPIF=0;
			CCPIE=1;	//打开中断
            GIE = 1;
		}

     }
}

void interrupt ISR(void)
{
   if(CCPIE == 1 && CCPIF == 1)
   {
		CCPIF = 0;
		if(ccp_count<SAMP_NUM)	//采集1次
		{
			ccpr_temp=((CCPR1H<<8) | CCPR1L);       //读取捕捉值
			if(start_flag==1)	                    //上次打印完成,启动下一次测量
			{
				ccpr_old=ccpr_temp;
				start_flag=2;
			}
			else if(start_flag==2)		        //计数累加
			{
				if(ccpr_temp < ccpr_old)
                {
					ccpr_delt = (4095-ccpr_old)+ccpr_temp+1;
                }
				else
                {
					ccpr_delt = ccpr_temp-ccpr_old;
                }
				ccpr_buf = ccpr_delt;
				ccpr_old=ccpr_temp;
				ccp_count++;
                CCPIE=0;	//关闭中断
                start_flag=3; //采集结束
			}
		}
   }
}

